Struct update syntax was used without a base expression.

Erroneous code example:

```compile_fail,E0797
struct Foo {
    fizz: u8,
    buzz: u8
}

let f1 = Foo { fizz: 10, buzz: 1};
let f2 = Foo { fizz: 10, .. }; // error
```

Using struct update syntax requires a 'base expression'.
This will be used to fill remaining fields.

```
struct Foo {
    fizz: u8,
    buzz: u8
}

let f1 = Foo { fizz: 10, buzz: 1};
let f2 = Foo { fizz: 10, ..f1 };
```
